<?php if($result): ?>
<style>
    .courierSummeryFraud tr td img {
        max-height: 40px;
    }
    .courierSummeryFraud tr th {
        background: #e5e7eb;
        padding: 6px;
        text-align: center;
        text-wrap: nowrap;
        min-width: 100px;
        border: 1px solid #dee2e6;
    }
    .courierSummeryFraud tr td {
        vertical-align: middle;
        padding: 6px;
        text-align: center;
        border: 1px solid #dee2e6;
    }
    .cusOrderTable tr td {
        vertical-align: middle;
    }
</style>

<div style="text-align:center;">
    <h3 style="font-size: 28px;">Fraud Tracker Report</h3>
    <p style="color: #24d164;">[ <?php echo e($result->customerPhone); ?> ]</p>
</div>

<div class="row">
    <div class="col-md-1"></div>
    <div class="col-md-10">
        <?php if($result->total_ratio > 0): ?>
        <?php
            $progressColor = $result->total_ratio > 50 ? '#629e75' : ($result->total_ratio > 20 ? '#f0ad4e' : '#ff4d4f');
        ?>
        <div style="box-shadow: 0 1px 4px 0 rgba(0, 0, 0, .1);padding: 10px 20px;text-align: center;background: #f9fafb;margin-bottom: 20px;">
            <?php if($result->total_ratio > 50): ?>
                <span>Customer is awesome</span>
            <?php elseif($result->total_ratio > 20): ?>
                <span>Customer is good</span>
            <?php else: ?>
                <span>Customer is not good</span>
            <?php endif; ?>
            
            <div class="progress" style="height: 20px;background-color: #ff4d4f;">
              <div class="progress-bar" role="progressbar" style="width: <?php echo e($result->total_ratio); ?>%;background-color: <?php echo e($progressColor); ?>;" aria-valuenow="<?php echo e($result->total_ratio); ?>" aria-valuemin="0" aria-valuemax="100">
                Success rate - <?php echo e($result->total_ratio); ?>%
              </div>
            </div>
        </div>
        <?php else: ?>
        <div style="box-shadow: 0 1px 4px 0 rgba(0, 0, 0, .1);padding:20px;text-align: center;background: #ffdbdc;margin-bottom: 20px;font-size: 30px;">
            <span>No Courier Data Found</span>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php if($result->total_ratio > 0): ?>
<div class="row">
    <div class="col-md-4">
        <div class="widget-rounded-circle card-box order" style="background: #d3e0fb;padding: 1.3rem;">
            <div class="text-center">
                <h3 class="text-dark m-0" style="font-size: 28px;">
                    <span><?php echo e($result->total_parcels); ?></span>
                </h3>
                <p class="m-0 text-truncate" style="color: black;">Total</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="widget-rounded-circle card-box order" style="background: #ccead5;padding: 1.3rem;">
            <div class="text-center">
                <h3 class="text-dark m-0" style="font-size: 28px;">
                    <span><?php echo e($result->total_delivered); ?></span>
                </h3>
                <p class="m-0 text-truncate" style="color: black;">Delivered</p>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="widget-rounded-circle card-box order" style="background: #ffdbdc;padding: 1.3rem;">
            <div class="text-center">
                <h3 class="text-dark m-0" style="font-size: 28px;">
                    <span><?php echo e($result->total_canceled); ?></span>
                </h3>
                <p class="m-0 text-truncate" style="color: black;">Returned</p>
            </div>
        </div>
    </div>
</div>
<br>

<div class="table-responsive">
    <table class="table table-bordered courierSummeryFraud permission-table">
        <thead class="bg-gray-200">
            <tr>
                <th>Courier</th>
                <th>Total</th>
                <th>Delivered</th>
                <th>Returned</th>
                <th>Success Ratio</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $result->purcelsdatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courier => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr class="<?php if($loop->even): ?> bg-gray-100 <?php else: ?> bg-white <?php endif; ?>">
                    <td>
                        <img src="<?php echo e(asset('public/backend/images/' . strtolower(str_replace(' ', '', $courier)) . '.png')); ?>" alt="img" class="w-2/6 h-auto object-contain block mx-auto">
                    </td>

                    <?php
                        $total = $delivered = $returned = 0;
                    ?>

                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($key == 'Total Parcels' || $key == 'Total Delivery'): ?>
                            <?php $total += $value; ?>
                            <td><?php echo e($total); ?></td>
                        <?php elseif($key == 'Delivered Parcels' || $key == 'Successful Delivery'): ?>
                            <?php $delivered += $value; ?>
                            <td><?php echo e($delivered); ?></td>
                        <?php elseif($key == 'Canceled Parcels' || $key == 'Canceled Delivery'): ?>
                            <?php $returned += $value; ?>
                            <td><?php echo e($returned); ?></td>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    <?php
                        $successRatio = $total > 0 ? round(($delivered / $total) * 100, 2) : 0;
                    ?>
                    <td><?php echo e($successRatio); ?>%</td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php $__currentLoopData = $result->purcelsdatas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $courier => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if(isset($data['Details']) && is_array($data['Details']) && count($data['Details']) > 0): ?>
                <tr>
                    <td colspan="5" style="text-align: left; color: #ff4d4f;">
                        <strong>Details:</strong>
                        <ul>
                            <?php $__currentLoopData = $data['Details']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detail): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($detail); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </td>
                </tr>
            <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>


<hr>
<br>

<div class="table-responsive">
    <p style="font-weight: bold;text-align: center;color: black">Customer Order History</p>

    <?php
        $number = $result->customerPhone ?: '000000000000';
        $oldOrders = App\Models\Order::whereHas('user', function($q) use ($number) {
            $q->where('mobile','like','%' . $number . '%');
        })->get();
    ?>

    <table class="table table-bordered cusOrderTable">
        <tr>
            <th style="width:100px;min-width:100px;">Order ID</th>
            <th style="min-width:300px;">Product Info</th>
            <th style="width:100px;min-width:100px;">Status</th>
        </tr>
        <?php $__currentLoopData = $oldOrders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oldOrder): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($oldOrder->invoice_no); ?></td>
                <td>
                    <?php $__currentLoopData = $oldOrder->details()->whereHas('product')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div style="display: flex;align-items: center;margin-bottom: 5px;">
                            <img src="<?php echo e(getImage('products', $item->product->image)); ?>" style="width:40px;height:40px;margin-right: 10px;">
                            <div>
                                <?php echo e($item->product->name); ?> <br>
                                Amount: <?php echo e(number_format($item->unit_price * $item->quantity)); ?> TK <br>
                                QTY: <?php echo e($item->quantity); ?>

                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
                <td><?php echo e($oldOrder->status); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </table>
</div>

<?php endif; ?>

<?php else: ?>
<h3>No order Found</h3>
<?php endif; ?>
<?php /**PATH /home/deshishop/public_html/resources/views/backend/orders/fraudOrder.blade.php ENDPATH**/ ?>