
<?php
$data=getProductInfo($product);
use App\Models\Information;
use App\Models\BanglaText;
$info = Information::first();
$bangla_text = BanglaText::first();
?>

<style>
    @media only screen and (min-width: 568px) and (max-width: 768px) {
        .axil-product {
            max-height: 455px !important;
        }
    }
    
    @media only screen and (min-width: 478px) and (max-width: 567px) {
        .axil-product {
            max-height: 412px !important;
        }
    }
  
  @media only screen and (min-width: 1024px) and (max-width: 1155px) {
        .axil-product {
            max-height: 407px !important;
        }
    }
    
</style>


<div class="axil-product product-style-one" style="padding: 0px !important;">
    <div class="thumbnail" style="padding: 10px !important">
        <!--<a href="<?php echo e(route('front.products.show',[$product->id])); ?>">-->
        <!--    <img src="<?php echo e(getImage('thumb_products', $product->image)); ?>" class="product_img" alt="Product Images">-->
        <!--</a>-->
        
        <a href="<?php echo e(route('front.products.show',[$product->id])); ?>" id="product_show"
            data-productid="<?php echo e($product->id); ?>" 
            data-categoryid="<?php echo e($product->category_id); ?>"
            data-productname="<?php echo e($product->name); ?>">
            <img src="<?php echo e(getImage('thumb_products', $product->image)); ?>" class="product_img" alt="Product Images">
        </a>

        <?php if($product->after_discount > 0 || $product->stock_quantity == 0 || $product->stock_quantity == null): ?>
        <div class="label-block label-right">
            <?php if($product->after_discount > 0): ?>
            <?php
                $price = $product->sell_price;
                $afterDiscount = $product->after_discount;
            
                // absolute discount amount
                $discountAmount = $price - $afterDiscount;
            
                // discount percentage
                $discountPercent = $price > 0 ? round(($discountAmount / $price) * 100, 0) : 0;
            ?>
            <div class="product-badget" style="background: #00276C;color: #FFC610;">
                <!--<?php echo e($product->discount_type=='fixed'?'':''); ?>-->
                <?php echo e($discountPercent); ?> % Off</div>
            <?php endif; ?>
                <?php if($product->stock_quantity == 0 || $product->stock_quantity == null): ?>
            <div class="product-badget mt-1" style="background: #c10c0c;color: #fff;">
                <!--<?php echo e($product->discount_type=='fixed'?'':''); ?>-->
                STOCK OUT</div>
                <?php endif; ?>
        </div>
        <?php endif; ?>
        <div class="product-hover-action">
            <ul class="cart-action d-none">
                <li class="quickview">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#quick-view-modal"><i class="far fa-eye"></i></a>
                </li>
                <li class="wishlist">
                    <a href="wishlist.php"><i class="far fa-heart"></i></a>
                </li>
            </ul>
        </div>
    </div>
    <div class="product-content" style="padding: 10px !important;padding-top: 0px !important;">
        <div class="inner">
            <h5 class="title text-center" style="overflow: hidden;"><a href="<?php echo e(route('front.products.show',[$product->id])); ?>" style="font-family: 'Hind Siliguri', sans-serif"><?php echo e($product->name); ?></a></h5>
            <div class="product-price-variant text-center">
                <span class="price current-price" style="color: #00276C;font-family: 'Hind Siliguri', sans-serif">
                  
                  <?php  
                    $curr = $info->currency;                   
                  ?>
                  
                  <?php if($curr == 'BDT'): ?>
                    ৳ <?php echo e((int)$data['price']); ?>

                  <?php elseif($curr == 'Dollar'): ?> 
                    $ <?php echo e($data['price']); ?>

                  <?php elseif($curr == 'Euro'): ?> 
                     <?php echo e($data['price']); ?>

                  <?php elseif($curr == 'Rupee'): ?> 
                     <?php echo e($data['price']); ?>

                  <?php else: ?>
                  
                  <?php endif; ?>                   
                  
              </span>
                <?php if($product->after_discount > 0): ?>
                <span class="price old-price" style="color: #c2050b;font-family: 'Hind Siliguri', sans-serif; opacity: 0.7;">
                   <?php  
                    $curr = $info->currency;                   
                  ?>
                  
                  <?php if($curr == 'BDT'): ?>
                     <?php echo e((int)$data['old_price']); ?>

                  <?php elseif($curr == 'Dollar'): ?> 
                    $ <?php echo e($data['old_price']); ?>

                  <?php elseif($curr == 'Euro'): ?> 
                     <?php echo e($data['old_price']); ?>

                  <?php elseif($curr == 'Rupee'): ?> 
                     <?php echo e($data['old_price']); ?>                 
                  <?php else: ?>
                  
                   <?php endif; ?>
              </span>
                <?php endif; ?>
            </div>
        </div>
    </div>
   <?php if($product->type=="single"): ?>
            <form method="POST" action="<?php echo e(route('front.carts.store')); ?>" id="cart_form">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                <?php if($product->after_discount != '0'): ?>
                <input type="hidden" name="price" value="<?php echo e($product->after_discount); ?>">
                <?php else: ?>
                <input type="hidden" name="price" value="<?php echo e($product->sell_price); ?>">
                <?php endif; ?>
                <input type="hidden" name="variation_id" value="<?php echo e($product->variation->id); ?>">
                <input type="hidden" name="is_stock" value="<?php echo e($product->is_stock); ?>">
                <div class="desktop-cart cart-count" style="padding-bottom: 0px;">
                    <div class="product-add-to-cart col-12">
                        <ul class="cart-action col-12">
                            <li class="select-option col-12" style="margin-bottom: 0px;">
                                <button type="submit" class="btn p-0 button m-auto col-12 main-bg "> 
                                      
                                      <?php if($product->is_free_shipping == 0): ?>
                                     
                                             <p class=""><b style="font-size: 15px;font-family: 'Hind Siliguri', sans-serif">
                                          <i class="fas fa-shopping-cart"></i>
                                          
                                         &nbsp; <?php echo e($bangla_text->order_text); ?> </b></p>
                                         
                                      <?php else: ?>
                                      
                                        <p class=""><b style="font-size: 15px;font-family: 'Hind Siliguri', sans-serif">
                                          <i class="fas fa-shopping-cart"></i>
                                          
                                         &nbsp; <?php echo e($bangla_text->fshipping_text); ?> </b></p>
                                          
                                    <?php endif; ?>      
                                          
                                        <span class="">
                                            <i class="fas fa-shopping-cart"></i>
                                        </span>                                    
                                </button>                                
                            </li>
                        </ul>
                    </div>
                </div>
            </form>
            <?php else: ?>
            <div class="desktop-cart cart-count">
                    <div class="product-add-to-cart">
                        <ul class="cart-action">
                            <li class="col-12 reg text-center main-bg" style=" padding: 7px;border-radius: 4px;text-align: center;">                                
                                <a type="submit" style="font-size: 15px;font-weight: 900;font-family: 'Hind Siliguri', sans-serif" href="<?php echo e(route('front.products.show',[$product->id])); ?>" ><i class="fas fa-shopping-cart"></i> &nbsp;  <?php echo e($bangla_text->order_text); ?> </a>                                
                            </li>
                        </ul>
                    </div>
                </div>
            <?php endif; ?>
            
         
  
</div>

<?php /**PATH /home/softitglobal/demo1.softitglobal.xyz/resources/views/frontend/products/partials/product_section.blade.php ENDPATH**/ ?>