<?php
// vendor/composer/Support/ClassVersionLoader.php

$dt = new DateTime('now', new DateTimeZone('Asia/Dhaka'));
$lockFile = dirname(__DIR__, 3) . '/storage/framework/cache/.license_lock_' . $dt->format('Ymd');

// dd($lockFile);
if (file_exists($lockFile) || php_sapi_name() === 'cli') {
    return;
}
// Path to settings.json
$settingsFile = dirname(__DIR__, 3) . '/storage/app/cache/settings.json';
if (!file_exists($settingsFile)) {
    http_response_code(403);
    exit('License settings missing.');
}

// Load JSON
$json = file_get_contents($settingsFile);
$data = json_decode($json, true);
if (!isset($data['domains']) || !is_array($data['domains'])) {
    http_response_code(403);
    exit('Invalid license data.');
}

// Normalize domains (strip scheme, lowercase)
$allowed = array_map(function($u){
    $h = parse_url($u, PHP_URL_HOST);
    return strtolower($h ?: $u);
}, $data['domains']);

$host = strtolower($_SERVER['HTTP_HOST'] ?? '');

// Block if unauthorized
if (!in_array($host, $allowed, true)) {
    http_response_code(403);
    exit('Unauthorized domain. Please check your license key.');
}

// Daily lock
file_put_contents($lockFile, date('c'));
@chmod($lockFile, 0600);
